/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import snownee.kiwi.Kiwi;
import snownee.kiwi.config.ConfigHandler;

public class KiwiConfigManager {
    private static final List<ConfigHandler> allConfigs = Lists.newLinkedList();
    private static final Map<Class<?>, ConfigHandler> clazz2Configs = Maps.newHashMap();
    public static final Map<ResourceLocation, ForgeConfigSpec.BooleanValue> modules = Maps.newHashMap();

    public static synchronized void register(ConfigHandler configHandler) {
        allConfigs.add(configHandler);
        if (configHandler.getClass() != null) {
            clazz2Configs.put(configHandler.getClazz(), configHandler);
        }
    }

    public static void init() {
        Collections.sort(allConfigs, (a, b) -> a.getFileName().compareTo(b.getFileName()));
        HashSet settledMods = Sets.newHashSet();
        for (ConfigHandler config : allConfigs) {
            if (!config.isMaster()) continue;
            settledMods.add(config.getModId());
        }
        for (ConfigHandler config : allConfigs) {
            if (!config.isMaster() && config.getType() == ModConfig.Type.COMMON && !settledMods.contains(config.getModId())) {
                settledMods.add(config.getModId());
                config.setMaster(true);
            }
            config.init();
        }
        for (ResourceLocation rl : Kiwi.defaultOptions.keySet()) {
            if (settledMods.contains(rl.func_110624_b())) continue;
            settledMods.add(rl.func_110624_b());
            ConfigHandler configHandler = new ConfigHandler(rl.func_110624_b(), rl.func_110624_b() + "-modules.toml", ModConfig.Type.COMMON, null, true);
            configHandler.init();
        }
    }

    public static void preload() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        for (ConfigHandler configHandler : allConfigs) {
            if (!configHandler.isMaster()) continue;
            configHandler.forceLoad();
        }
    }

    public static void defineModules(String modId, ForgeConfigSpec.Builder builder) {
        builder.push("modules");
        for (Map.Entry<ResourceLocation, Boolean> entry : Kiwi.defaultOptions.entrySet()) {
            ResourceLocation rl = entry.getKey();
            if (!rl.func_110624_b().equals(modId)) continue;
            modules.put(rl, builder.define(rl.func_110623_a(), entry.getValue() == false));
        }
        builder.pop();
    }

    public static void refresh() {
        allConfigs.forEach(ConfigHandler::refresh);
    }

    public static ConfigHandler getHandler(Class<?> clazz) {
        return clazz2Configs.get(clazz);
    }
}

